function [PSF] = get_freedipolepsf(FieldMatrix,parameters)
% This function calculates the free dipole PSF given the field matrix.
%
% Sjoerd Stallinga, TU Delft

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

dims = size(FieldMatrix);
if (length(dims)>2)
    Mz = dims(3);
    imdims = size(FieldMatrix{1,1,1});
else
    Mz = 1;
    imdims = size(FieldMatrix{1,1});
end
Mx = imdims(1);
My = imdims(2);

% calculation of free dipole PSF
PSF = zeros(Mx,My,Mz);
for jz = 1:Mz
    for jtel = 1:3
        for itel = 1:2
            PSF(:,:,jz) = PSF(:,:,jz) + (1/3)*abs(FieldMatrix{itel,jtel,jz}).^2;
        end
    end
end

% plotting intermediate results
if parameters.debugmode
    jz = ceil(Mz/2);
    tempim = squeeze(PSF(:,:,jz));
    radialmeanPSF = im2mat(radialmean(tempim));
    radialmeanPSF = radialmeanPSF/max(radialmeanPSF);
    FWHM = 2*(sum(double(radialmeanPSF>0.5))-0.5)*parameters.pixelsize;
    fprintf('FWHM of PSF = %6.1f nm\n',FWHM)
    positionvec = (0:(length(radialmeanPSF)-1))*parameters.pixelsize;
    figure
    box on
    hold on
    %   plot(positionvec*parameters.NA/parameters.lambda,radialmeanPSF)
    %   xlabel('position [\lambda/NA]')
    %   xlim([0 3])
    %   plot([0 3],[0.5 0.5],'k')
    %   plot([FWHM*parameters.NA/parameters.lambda/2 FWHM*parameters.NA/parameters.lambda/2],[0 0.5],'--k')
    plot(positionvec,radialmeanPSF)
    xlabel('position [nm]')
    xlim([0 3*parameters.lambda/parameters.NA])
    plot([0 3*parameters.lambda/parameters.NA],[0.5 0.5],'k')
    plot([FWHM/2 FWHM/2],[0 0.5],'--k')
    ylabel('radial average PSF')
end

end

